Rem
Rem $Header: deq_xml.sql 11-jul-2003.15:49:54 kbittler Exp $
Rem
Rem deq_xml.sql
Rem
Rem Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      deq_xml.sql - Dequeues a message from MGWUSER.MGW_BOOK_DEST.
Rem
Rem    DESCRIPTION
Rem      This script dequeues a message from queue MGWUSER.MGW_BOOK_DEST.
Rem      If no message is available an exception is raised.
Rem
Rem    NOTES
Rem

DECLARE
  payload                mgwuser.book_order_t;
  dequeue_options        dbms_aq.dequeue_options_t;
  message_properties     dbms_aq.message_properties_t;
  msgid                  RAW(16);
BEGIN
  dequeue_options.wait := dbms_aq.NO_WAIT;
  dbms_aq.dequeue(queue_name         => 'mgwuser.mgw_book_dest',
                  dequeue_options    => dequeue_options,
                  message_properties => message_properties,
                  payload            => payload,
                  msgid              => msgid);

  commit;
END;
/

